﻿{
//Almo7tarif al arabi v5.1 - Mac Compatible
// Copyright © Issame NAHHALI.NET 
// issamnahhali@gmail.com 
// Nahhali.net 
//
// This script allows you to write arabic text using arabic glyphs.
// FIXED: Mac compatibility issues and error handling
//
// Usage:
// press Clear to erase text from Text Input, you can perform 
// insert,update or convert operations using DropDownList 
// and Apply Button.
//
// Note:
// for new line use CTRL+Enter.

    //Main class
    function ArabicText(){
        var AT = {};
        
        // Script info
        AT.scriptName = "Al Arabi LiVE | NAHHALI.NET";
        AT.scriptVersion = "5.1";
        AT.scriptSupportVersion = "6.0";
        AT.scriptTitle = AT.scriptName+" v"+AT.scriptVersion;
        AT.authorName = "Issame NAHHALI";
        AT.authorBlog = "https://Nahhali.net";
        AT.authorScripts = "https://Nahhali.net/alarabilive";
        AT.authorEmail = "mailto:issamnahhali@gmail.com";
        AT.authorInfo = "Scripts:"+AT.authorScripts+"\\n"+
                        "Blog:"+AT.authorBlog+"\\n"+
                        "Email:"+AT.authorEmail;
        AT.scriptCopyright = "Copyright © 2010 - 2025 "+AT.authorName;       
        AT.scriptAbout = "This script allows you to write arabic text using arabic glyphs.";
        AT.scriptUsage = "Press Clear to erase text from Text Input, you can perform insert,update or convert operations "+
                         "using DropDownList and Apply Button.";
        AT.scriptNote = "For new line use CTRL+Enter";
        
        // UI strings
        AT.strClear = "Clear";
        AT.strHelp = "?";
        AT.strBtnHelp1 = "Other Scripts";
        AT.strBtnHelp2 = "My Blog";
        AT.strProcess = "Apply";
        AT.strDwnText = ["New Text","Update Text","Convert Text"];
        
        // State variables
        AT.valInText = "";
        AT.valSelText = "";
        AT.valOutText = "";
        AT.valTextOpt = 0;
        
        // Arabic keyboard layout configuration
        var arabicKeys = [
            ["ض","ص","ث","ق","ف","غ","ع","ه","خ","ح","ج","د"],
            ["ش","س","ي","ب","ل","ا","ت","ن","م","ك","ط"],
            ["ئ","ء","ؤ","ر","لا","ى","ة","و","ز","ظ"],
            [" ", "⌫"]
        ];
        
        //Building GUI
        function buildUI(thisObj){
            try {
                var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", AT.scriptName, undefined, {resizeable:true});
                var res =
                "group { orientation:'column', alignment:['fill','fill'], alignChildren:['right','top'], \
                    tool:Group { orientation:'row', alignment:['fill','top'], alignChildren:['right','top'], \
                        btnClear:Button { alignment:['left','top'], text:'"+AT.strClear+"', preferredSize:[70,25]}, \
                        btnHelp:Button { alignment:['right','top'], text:'"+AT.strHelp+"', preferredSize:[25,25]} \
                    }, \
                    input:Group { orientation:'column', alignment:['fill','fill'], alignChildren:['right','top'], \
                        etxtInput:EditText{ alignment:['fill','fill'], preferredSize:[370,410] , text:'' ,properties:{multiline:true,noecho:false,readonly:false}}\
                    }, \
                    controls:Group {  orientation:'row', alignment:['fill','bottom'], \
                        dwnText:DropDownList{alignment:['fill','top'],preferredSize:[100,20]},\
                        btnProcess:Button { alignment:['right','top'], text:'"+AT.strProcess+"', preferredSize:[70,25]} \
                    } \
                  }";
                  
                pal.grp = pal.add(res);
                
                //Set the default value for controls
                for(var i=0; i<AT.strDwnText.length; i++) {
                    pal.grp.controls.dwnText.add("item", AT.strDwnText[i]);
                }
              
                pal.grp.controls.dwnText.selection = 0;
                AT.valTextOpt = 0;

                //Get input text
                pal.grp.input.etxtInput.onChanging = pal.grp.input.etxtInput.onChange = function (){
                    AT.valInText = this.text;
                };

                //Get text action option
                pal.grp.controls.dwnText.onChange = function (){
                    AT.valTextOpt = this.selection ? this.selection.index : 0;
                    pal.grp.input.etxtInput.enabled = (AT.valTextOpt !== 2);
                };       
                
                //when clear button clicked
                pal.grp.tool.btnClear.onClick = function(){
                    pal.grp.input.etxtInput.text = "";
                    AT.valInText = "";
                };
            
                //when apply button clicked
                pal.grp.controls.btnProcess.onClick = function(){
                    processText();
                };
                
                //when help button clicked
                pal.grp.tool.btnHelp.onClick = function(){
                    showHelp();
                };
                
                // Add Arabic keyboard
                addArabicKeyboard(pal);
                
                //enable resizing window
                pal.layout.layout(true);
                pal.layout.resize();      
                pal.onResizing = pal.onResize = function () {
                    this.layout.resize();
                };
                
                return pal;
                
            } catch (e) {
                alert("Error building UI: " + e.toString(), "Error");
                return null;
            }
        }
        
        // Add Arabic keyboard to the interface
        function addArabicKeyboard(pal) {
            try {
                pal.grp.add("statictext", undefined, "Arabic Keyboard:");
                pal.grp.keyboard = pal.grp.add("group", undefined, "keyboard");
                pal.grp.keyboard.orientation = "column";

                for (var i = 0; i < arabicKeys.length; i++) {
                    var row = pal.grp.keyboard.add("group");
                    row.orientation = "row";
                    
                    for (var j = 0; j < arabicKeys[i].length; j++) {
                        var keyChar = arabicKeys[i][j];
                        var btn = row.add("button", undefined, keyChar);
                        btn.preferredSize = [30, 30];
                        btn.userData = keyChar; // Store the character
                        
                        btn.onClick = function () {
                            try {
                                var textField = pal.grp.input.etxtInput;
                                if (this.userData === "⌫") {
                                    textField.text = textField.text.slice(0, -1);
                                } else {
                                    textField.text += this.userData;
                                }
                                AT.valInText = textField.text;
                            } catch (e) {
                                // Silent fail for keyboard input errors
                            }
                        };
                    }
                }
            } catch (e) {
                // Keyboard is optional, don't break the whole script
            }
        }
        
        //The main processing function
        function processText(){
            try {
                if (!validateEnvironment()) return;
                
                if(AT.valTextOpt === 0){
                    // New Text
                    if (!AT.valInText) {
                        alert("No Input Text", "Error");
                        return;
                    }
                    
                    AT.valOutText = convertText(AT.valInText);
                    AT.valOutText = processMultiLine(AT.valOutText);
                    
                    app.beginUndoGroup("ArabicText");
                    var curLayer = app.project.activeItem.layers.addText("Arabic Text");
                    curLayer.property("ADBE Text Properties").property("ADBE Text Document").setValue(AT.valOutText);
                    curLayer.name = AT.valInText.substring(0, 30); // Limit name length
                    app.endUndoGroup();
                    
                } else if(AT.valTextOpt === 1) { 
                    // Update Text
                    if (!AT.valInText) {
                        alert("No Input Text", "Error");
                        return;
                    }
                    
                    if (!validateSelection()) return;
                    
                    AT.valOutText = convertText(AT.valInText);
                    AT.valOutText = processMultiLine(AT.valOutText);
                    
                    app.beginUndoGroup("ArabicText Update");
                    var selLayers = app.project.activeItem.selectedLayers;
                    for(var i = 0; i < selLayers.length; i++){
                        if(selLayers[i] instanceof TextLayer){
                            selLayers[i].property("ADBE Text Properties").property("ADBE Text Document").setValue(AT.valOutText);
                            selLayers[i].name = AT.valInText.substring(0, 30);
                        }
                    }
                    app.endUndoGroup();
                
                } else if(AT.valTextOpt === 2) { 
                    // Convert Text
                    if (!validateSelection()) return;
                    
                    app.beginUndoGroup("ArabicText Convert");
                    var selLayers = app.project.activeItem.selectedLayers;
                    for(var i = 0; i < selLayers.length; i++){
                        if(selLayers[i] instanceof TextLayer){
                            try {
                                AT.valSelText = selLayers[i].property("ADBE Text Properties").property("ADBE Text Document").value.toString();
                                AT.valOutText = convertText(AT.valSelText);
                                AT.valOutText = processMultiLine(AT.valOutText);
                                selLayers[i].property("ADBE Text Properties").property("ADBE Text Document").setValue(AT.valOutText);
                            } catch (e) {
                                // Skip layers with issues
                                continue;
                            }
                        }
                    }
                    app.endUndoGroup();              
                }
            } catch (e) {
                alert("Error processing text: " + e.toString(), "Error");
            }
        }
    
        // Validation functions
        function validateEnvironment(){
            try {
                var thisComp = app.project.activeItem;
                if (thisComp == null || !(thisComp instanceof CompItem)){
                    alert("Please Select A Composition", "Error"); 
                    return false;
                }
                return true;
            } catch (e) {
                alert("Environment validation error: " + e.toString(), "Error");
                return false;
            }
        }
        
        function validateSelection(){
            try {
                var selectLayers = app.project.activeItem.selectedLayers;
                if(selectLayers.length < 1){
                     alert("Please Select A Layer(s)", "Error");
                     return false;
                }
                
                var hasTextLayer = false;
                for(var i = 0; i < selectLayers.length; i++){
                    if(selectLayers[i] instanceof TextLayer) {
                        hasTextLayer = true;
                        break;
                    }
                }
                
                if(!hasTextLayer){
                    alert("Please Select A Text Layer(s)", "Error");
                    return false;
                }
                
                return true;
            } catch (e) {
                alert("Selection validation error: " + e.toString(), "Error");
                return false;
            }
        }
    
        //Help window - FIXED for Mac compatibility
        function showHelp(){
            try {
                var pal = new Window("dialog", AT.scriptTitle, undefined, {resizeable:false});
                var res = 
                "group { orientation:'column', alignment:['left','top'], alignChildren:['right','top'], \
                    help:Group { alignment:['left','top'],orientation:'column', \
                        txtHead:StaticText { alignment:['left','top'],text:'"+AT.scriptTitle+"'}, \
                        txtCopyright:StaticText { alignment:['left','top'],text:'"+AT.scriptCopyright+"'} \
                        }, \
                    group:Group { alignment:['left','top'], \
                        txtDef: EditText { text:' \\n"+AT.scriptAbout+"\\n\\nUsage: "+AT.scriptUsage+"\\n\\nNote: "+AT.scriptNote+"\\n\\n"+AT.authorInfo+"', alignment:['fill','fill'], preferredSize:[300,120], properties:{multiline:true,readonly:true}} \
                        }, \
                    controls:Group { alignment:['fill','bottom'], \
                        btnBlog:Button { text:'My Blog', preferredSize:[70,25],alignment:['left','bottom']}, \
                        btnScripts:Button { text:'Scripts', preferredSize:[70,25],alignment:['right','bottom']} \
                    } \
                }";
                
                pal.grp = pal.add(res);
                
                pal.grp.controls.btnBlog.onClick = function(){
                    openURL(AT.authorBlog);
                };
            
                pal.grp.controls.btnScripts.onClick = function(){
                    openURL(AT.authorScripts);
                };
            
                pal.layout.layout(true);
                pal.layout.resize();          
                pal.onResizing = pal.onResize = function (){
                    this.layout.resize();
                };
                
                pal.center();
                pal.show();
            } catch (e) {
                alert("Error showing help: " + e.toString(), "Error");
            }
        }
        
        // FIXED: Cross-platform URL opening
        function openURL(url){
            try {
                // More robust OS detection
                var os = $.os.toLowerCase();
                
                if (os.indexOf("windows") >= 0) {
                    // Windows
                    system.callSystem('cmd /c start "" "' + url + '"');
                } else if (os.indexOf("mac") >= 0) {
                    // macOS - FIXED
                    system.callSystem('open "' + url + '"');
                } else {
                    // Linux/Unix fallback
                    system.callSystem('xdg-open "' + url + '"');
                }
            } catch (e) {
                // Fallback: copy URL to clipboard and inform user
                try {
                    system.callSystem('echo "' + url + '" | pbcopy'); // Mac clipboard
                } catch (e2) {
                    // If all else fails, show URL
                    alert("Please visit: " + url, "Open URL");
                }
            }
        }
        
        //Execution function
        this.run = function(thisObj){
            try {
                // Better version checking
                var version = parseFloat(app.version);
                var minVersion = parseFloat(AT.scriptSupportVersion);
                
                if (version < minVersion) {
                    alert("This script requires After Effects CS3 (" + AT.scriptSupportVersion + ") or later.\nCurrent version: " + app.version, "Version Error");
                    return;
                }
                
                var win = buildUI(thisObj);
                if (win != null && win instanceof Window) {
                    win.center();
                    win.show();
                } else if (win != null) {
                    // Panel mode
                    win.layout.layout(true);
                }
            } catch (e) {
                alert("Script initialization error: " + e.toString(), "Error");
            }
        };
        
        // IMPROVED: Text conversion with better error handling
        function convertText(inTxt){
            try {
                if (!inTxt) return "";
                
                var conTxt = "", temp = "", temp2 = "";
                var cur = -1, nxt = -1, prv = -1;
                
                for(var i = 1; i < inTxt.length + 1; i++){
                    
                    if(i > 1){
                        nxt = inTxt[inTxt.length-(i-1)];
                        if(checkTashkeel(nxt)) {
                            nxt = inTxt[inTxt.length-(i-2)];
                        }
                    } else {
                        nxt = -1;
                    }
                    
                    cur = inTxt[inTxt.length-i];
                    
                    if(i < inTxt.length){
                        prv = inTxt[inTxt.length-(i+1)];
                        if(checkTashkeel(prv)) {
                            prv = inTxt[inTxt.length-(i+2)];
                        }
                    } else {
                        prv = -1;
                    }
      
                    var indxCur = indexOf(form0, cur);

                    if(indxCur < 0 ){
                        if(inTxt.charCodeAt(inTxt.length-i) == 8204) {
                            continue;
                        }
                            
                        if(indexOf(leftBrackets, cur) >= 0) {
                            cur = rightBrackets[indexOf(leftBrackets, cur)];
                        } else if(indexOf(rightBrackets, cur) >= 0) {
                            cur = leftBrackets[indexOf(rightBrackets, cur)];
                        }
                         
                        if(indexOf(form0, prv) >= 0 || inTxt.charCodeAt(inTxt.length-i) == 13 || indexOf(specChar, cur) >=0 || indexOf(leftBrackets, cur) >= 0 || indexOf(rightBrackets, cur) >= 0 || prv < 0){
                            if(indexOf(specChar, cur) >= 0 || indexOf(leftBrackets, cur) >= 0 || indexOf(rightBrackets, cur) >= 0 || inTxt.charCodeAt(inTxt.length-i) == 13) {
                                conTxt += temp + cur;
                            } else {
                                conTxt += cur + temp;
                            }
                            temp = "";
                        } else {
                            temp = cur + temp;
                        }
                            
                   } else if((cur == 'ا' && prv == 'ل')||(cur == 'أ' && prv == 'ل')||(cur == 'إ' && prv == 'ل')||(cur == 'آ' && prv == 'ل')) {
                        continue;
                    } else if(cur == 'ل' && nxt == 'ا' && !checkConnection(prv)) {
                        conTxt+='\uFEFB';
                    } else if(cur == 'ل' && nxt == 'ا' && checkConnection(prv)) {
                        conTxt+='\uFEFC';
                    } else if(cur == 'ل' && nxt == 'أ' && !checkConnection(prv)) {
                        conTxt+='\uFEF7';
                    } else if(cur == 'ل' && nxt == 'أ' && checkConnection(prv)) {
                        conTxt+='\uFEF8';
                    } else if(cur == 'ل' && nxt == 'إ' && !checkConnection(prv)) {
                        conTxt+='\uFEF9';
                    } else if(cur == 'ل' && nxt == 'إ' && checkConnection(prv)) {
                        conTxt+='\uFEFA';
                    } else if(cur == 'ل' && nxt == 'آ' && !checkConnection(prv)) {
                        conTxt+='\uFEF5';
                    } else if(cur == 'ل' && nxt == 'آ' && checkConnection(prv)) {
                        conTxt+='\uFEF6';
                    } else if(!checkConnection(prv) && indexOf(form0, nxt) < 0) {     
                        conTxt += form0[indxCur];
                    } else if(!checkConnection(prv) && indexOf(form0, nxt) >= 0) {
                        conTxt += form2[indxCur];
                    } else if(checkConnection(prv) && indexOf(form0, nxt) >= 0) {
                        conTxt += form3[indxCur];
                    } else if(checkConnection(prv) && indexOf(form0, nxt) < 0) {
                        conTxt += form1[indxCur];
                    }
                }
                
                return conTxt;
            } catch (e) {
                alert("Error converting text: " + e.toString(), "Error");
                return inTxt; // Return original text if conversion fails
            }
        }
    
        function processMultiLine(conText){
            try {
                var push = "", pop = "", cur = "";
                for(var g = 0; g < conText.length; g++){
                    cur = conText[g];
                    if(cur == '\n' || conText.charCodeAt(g) == 13){
                        push = '\n\r' + pop + push;
                        pop = "";
                    } else {
                        pop += cur;
                    }
                }
                return pop + push;
            } catch (e) {
                return conText; // Return original if processing fails
            }
        }

        // Helper functions
        function indexOf(arr, ch){
            for(var j = 0; j < arr.length; j++){
                if(ch == arr[j]) {
                    return j;
                }
            }
            return -1;
        }
        
        function checkTashkeel(ch){
            for(var n = 0; n < tashkeel.length; n++){
                if(ch == tashkeel[n]) {
                    return true;
                }
            }
            return false;
        }
    
        function checkConnection(ch){
            var isConnectable = false;
            for(var m = 0; m < form0.length; m++){
                if(ch == form0[m]) {
                    isConnectable = true;
                    break;
                }
            }
            for(var k = 0; k < nonConnectable.length; k++){
                if(ch == nonConnectable[k]) {
                    isConnectable = false;
                    break;
                }
            }
            return isConnectable;
        }
        
        //Character definitions - moved to bottom for better organization
        var specChar = ['\n','\n\r',' ','-','.'];
        var leftBrackets = ['(','{','[','<','«'];
        var rightBrackets = [')','}',']','>','»'];
        var tashkeel = ['َ','ً','ِ','ٍ','ُ','ٌ','ّ'];
        var nonConnectable = ['ا','ة','د','ذ','ر','ز','و','ى','ؤ','ء','أ','إ','آ','ﮊ','ﭐ','ﮂ','ﮄ','ﮈ','ﮆ','ﮊ','ﮌ','ﮞ','ﮤ','ﯠ','ﯢ','ﯗ','ﯙ','ﯛ','ﯞ','ﮮ','ﮰ','ﻵ','ﻷ','ﻹ','ﻻ'];
        
        //Isolated form
        var form0 =  ['ا'     ,'ب'     ,'ة'     ,'ت'     ,'ث'	   ,'ج'     ,'ح'     ,'خ'     ,'د'     ,'ذ'     ,'ر'     ,'ز'     ,'س'     ,'ش'     ,'ص'     ,'ض'     ,'ط'     ,'ظ'     ,'ع'     ,'غ'     ,'ف'     ,'ق'     ,'ك'     ,'ل'     ,'م'     ,'ن'     ,'ه'     ,'و'     ,'ي'     ,'ى'     ,'ؤ'     ,'ئ'     ,'أ'     ,'إ'     ,'آ'     ,'ﭐ'     ,'پ'     ,'چ'     ,'ژ'     ,'گ'     ,'ی'     ,'ک'     ,'ﭦ'     ,'ﭞ'     ,'ﭒ'     ,'ﭖ'     ,'ﭢ'     ,'ﭚ'     ,'ﭲ'     ,'ﭶ'     ,'ﭺ'     ,'ﭾ'     ,'ﮈ'     ,'ﮄ'     ,'ﮂ'     ,'ﮆ'     ,'ﮌ'     ,'ﮊ'     ,'ﭪ'     ,'ﭮ'     ,'ﯓ'     ,'ﮒ'     ,'ﮚ'     ,'ﮖ'     ,'ﮞ'     ,'ﮠ'     ,'ﮪ'     ,'ﮤ'     ,'ﮦ'     ,'ﯠ'     ,'ﯙ'     ,'ﯗ'     ,'ﯛ'     ,'ﯢ'     ,'ﯞ'     ,'ﯼ'     ,'ﯤ'     ,'ﮮ'     ,'ﮰ'     ,'ﻵ'     ,'ﻷ'     ,'ﻹ'     ,'ﻻ'     ,'ـ'     ,'ء'     ];
        //Final form
        var form1 =  ['\uFE8E','\uFE90','\uFE94','\uFE96','\uFE9A','\uFE9E','\uFEA2','\uFEA6','\uFEAA','\uFEAC','\uFEAE','\uFEB0','\uFEB2','\uFEB6','\uFEBA','\uFEBE','\uFEC2','\uFEC6','\uFECA','\uFECE','\uFED2','\uFED6','\uFEDA','\uFEDE','\uFEE2','\uFEE6','\uFEEA','\uFEEE','\uFEF2','\uFEF0','\uFE86','\uFE8A','\uFE84','\uFE88','\uFE82','\uFB51','\uFB57','\uFB7B','\uFB8B','\uFB93','\uFBFD','\uFB8F','\uFB67','\uFB5F','\uFB53','\uFB57','\uFB63','\uFB5B','\uFB73','\uFB77','\uFB7B','\uFB7F','\uFB89','\uFB85','\uFB83','\uFB87','\uFB8D','\uFB8B','\uFB6B','\uFB6F','\uFBD4','\uFB93','\uFB9B','\uFB97','\uFB9F','\uFBA1','\uFBAB','\uFBA5','\uFBA7','\uFBE1','\uFBDA','\uFBD8','\uFBDC','\uFBE3','\uFBDF','\uFBFD','\uFBE5','\uFBAF','\uFBB1','\uFEF6','\uFEF8','\uFEFA','\uFEFC','\u0640','\u0621'];
        //Initial form
        var form2 =  ['\uFE8D','\uFE91','\uFE94','\uFE97','\uFE9B','\uFE9F','\uFEA3','\uFEA7','\uFEA9','\uFEAB','\uFEAD','\uFEAF','\uFEB3','\uFEB7','\uFEBB','\uFEBF','\uFEC3','\uFEC7','\uFECB','\uFECF','\uFED3','\uFED7','\uFEDB','\uFEDF','\uFEE3','\uFEE7','\uFEEB','\uFEED','\uFEF3','\uFEEF','\uFE85','\uFE8B','\uFE83','\uFE87','\uFE81','\uFB50','\uFB58','\uFB7C','\uFB8A','\uFB94','\uFBFE','\uFB90','\uFB68','\uFB60','\uFB54','\uFB58','\uFB64','\uFB5C','\uFB74','\uFB78','\uFB7C','\uFB80','\uFB88','\uFB84','\uFB82','\uFB86','\uFB8C','\uFB8A','\uFB6C','\uFB70','\uFBD5','\uFB94','\uFB9C','\uFB98','\uFB9E','\uFBA2','\uFBAC','\uFBA4','\uFBA8','\uFBE0','\uFBD9','\uFBD7','\uFBDB','\uFBE2','\uFBDE','\uFBFE','\uFBE6','\uFBAE','\uFBB0','\uFEF5','\uFEF7','\uFEF9','\uFEFB','\u0640','\u0621'];
        //Medial form
     var form3 =  ['\uFE8E','\uFE92','\uFE94','\uFE98','\uFE9C','\uFEA0','\uFEA4','\uFEA8','\uFEAA','\uFEAC','\uFEAE','\uFEB0','\uFEB4','\uFEB8','\uFEBC','\uFEC0','\uFEC4','\uFEC8','\uFECC','\uFED0','\uFED4','\uFED8','\uFEDC','\uFEE0','\uFEE4','\uFEE8','\uFEEC','\uFEEE','\uFEF4','\uFEF0','\uFE86','\uFE8C','\uFE84','\uFE88','\uFE82','\uFB51','\uFB59','\uFB7D','\uFB8B','\uFB95','\uFBFF','\uFB91','\uFB69','\uFB61','\uFB55','\uFB59','\uFB65','\uFB5D','\uFB75','\uFB79','\uFB7D','\uFB81','\uFB89','\uFB85','\uFB83','\uFB87','\uFB8D','\uFB8B','\uFB6D','\uFB71','\uFBD6','\uFB95','\uFB9D','\uFB99','\uFB9F','\uFBA3','\uFBAD','\uFBA5','\uFBA9','\uFBE1','\uFBDA','\uFBD8','\uFBDC','\uFBE3','\uFBDF','\uFBFF','\uFBE7','\uFBAE','\uFBB1','\uFEF6','\uFEF8','\uFEFA','\uFEFC','\u0640','\u0621'];
    }

    //Execute main class
    new ArabicText().run(this);


}